package com.rapidminer.krimp.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.krimp.CodeTable;
import com.rapidminer.tools.Tools;

public class CodeTableVisualization extends JPanel {

	private static final long serialVersionUID = -4353590225271845908L;

	private final CodeTableModel modelCT;
	private final STCodeTableModel modelST;

	private final JLabel totalSizeLabel = new JLabel();
	private final JLabel compressedSizeLabel = new JLabel();
	private final JLabel standardCTLabel = new JLabel();

	public CodeTableVisualization(final CodeTable codeTable) {
		modelST = new STCodeTableModel(codeTable.getStandardCodeTable());
		codeTable.cleanUp();
		modelCT = new CodeTableModel(codeTable);
		setLayout(new BorderLayout());

		// main panel
		{
			JPanel mainPanel = new JPanel();
			mainPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.RAISED));
			add(mainPanel, BorderLayout.CENTER);
			GridBagLayout mainPanelGBL = new GridBagLayout();
			mainPanelGBL.columnWidths = new int[]{20,0,0};
			mainPanelGBL.rowHeights =new int[]{0,0};
			mainPanelGBL.columnWeights = new double[]{0.0,1.0,Double.MIN_VALUE};
			mainPanelGBL.rowWeights = new double[]{1.0,Double.MIN_VALUE};
			mainPanel.setLayout(mainPanelGBL);
			
			Component horStrut = Box.createHorizontalStrut(20);
			GridBagConstraints horStrutGBC = new GridBagConstraints();
			horStrutGBC.anchor = GridBagConstraints.WEST;
			horStrutGBC.fill = GridBagConstraints.VERTICAL;
			horStrutGBC.insets = new Insets(0,0,0,5);
			horStrutGBC.gridx = 0;
			horStrutGBC.gridy =0;
			mainPanel.add(horStrut,horStrutGBC);
			
			JTable table = new ExtendedJTable(this.modelCT, true, true, false);
			table.setBorder(BorderFactory
					.createEtchedBorder(EtchedBorder.RAISED));
			JScrollPane tablePane = new ExtendedJScrollPane(table);
			GridBagConstraints tablePaneGBC = new GridBagConstraints();
			tablePaneGBC.fill = GridBagConstraints.BOTH;
			tablePaneGBC.gridx = 1;
			tablePaneGBC.gridy =0;
			mainPanel.add(tablePane,tablePaneGBC);

			
		}

		// left panel
		{
			JPanel leftPanel = new JPanel();
			leftPanel.setBorder(new EtchedBorder(EtchedBorder.RAISED));
			GridBagLayout layout = new GridBagLayout();
			layout.columnWidths = new int[]{0,0};
			layout.rowHeights = new int[]{20,20,20,20,0,0};
			layout.columnWeights = new double[]{1.0,Double.MIN_VALUE};
			layout.rowWeights = new double[]{0.0,0.0,0.0,0,1.0,Double.MIN_VALUE};
			leftPanel.setLayout(layout);

			totalSizeLabel.setText("No. of Sets: "
					+ codeTable.getNumberOfEntrys());
			GridBagConstraints gbcTotSizeLbl = new GridBagConstraints();
			gbcTotSizeLbl.fill = GridBagConstraints.BOTH;
			gbcTotSizeLbl.gridx=0;
			gbcTotSizeLbl.gridy=0;
			leftPanel.add(totalSizeLabel,gbcTotSizeLbl);

			compressedSizeLabel.setText("Compressed size L(CT,D): "
					+ Tools.formatNumber(codeTable.getCompressedSize()));
			GridBagConstraints gbcComprSize = new GridBagConstraints();
			gbcComprSize.fill = GridBagConstraints.BOTH;
			gbcComprSize.gridx=0;
			gbcComprSize.gridy=1;
			leftPanel.add(compressedSizeLabel,gbcComprSize);

			standardCTLabel.setText("Standard Code Table:");
			GridBagConstraints gbcStCT = new GridBagConstraints();
			gbcStCT.fill = GridBagConstraints.BOTH;
			gbcStCT.gridx=0;
			gbcStCT.gridy=3;
			leftPanel.add(standardCTLabel,gbcStCT);

			JTable table = new ExtendedJTable(modelST, true, true, false);
//			table.setBorder(BorderFactory
//					.createEtchedBorder(EtchedBorder.RAISED));
			JScrollPane tablePane = new ExtendedJScrollPane(table);
			tablePane.setPreferredSize(new Dimension(245, 401));
//			tablePane
//					.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			GridBagConstraints gbcTable = new GridBagConstraints();
			gbcTable.fill = GridBagConstraints.BOTH;
			gbcTable.gridx=0;
			gbcTable.gridy=4;
			leftPanel.add(tablePane,gbcTable);
			

			add(leftPanel, BorderLayout.WEST);
		}
	}
}
